//
//  MoveMeController.m
//  Nav
//
//  Created by Robert Górczyński on 11-07-06.
//

#import "MoveMeController.h"


@implementation MoveMeController
@synthesize list; 

- (IBAction)toggleMove{ 
    [self.tableView setEditing:!self.tableView.editing animated:YES]; 
	
    if (self.tableView.editing)
        [self.navigationItem.rightBarButtonItem setTitle:@"Gotowe"]; 
    else 
        [self.navigationItem.rightBarButtonItem setTitle:@"Przenieś"]; 
} 


- (void)viewDidLoad { 
    if (list == nil) { 
        NSMutableArray *array = [[NSMutableArray alloc] initWithObjects: 
								 @"Ene", @"due", @"rabe", @"zjadł", @"Tadeusz", @"żabę", @"żaba",
								 @"Tadeusza", @"w", @"brzuchu", @"mu", @"się", @"rusza", nil]; 
        self.list = array; 
        [array release]; 
    } 
	
    UIBarButtonItem *moveButton = [[UIBarButtonItem alloc] 
                                   initWithTitle:@"Przenieś" 
                                   style:UIBarButtonItemStyleBordered 
                                   target:self 
                                   action:@selector(toggleMove)]; 
    self.navigationItem.rightBarButtonItem = moveButton; 
    [moveButton release]; 
    [super viewDidLoad]; 
} 

- (void)dealloc { 
    [list release]; 
    [super dealloc]; 
} 

#pragma mark - 
#pragma mark Metody źródła danych tabeli 
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return [list count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
         cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
	static NSString *MoveMeCellIdentifier = @"MoveMeCellIdentifier"; 
    UITableViewCell *cell = [tableView 
							 dequeueReusableCellWithIdentifier:MoveMeCellIdentifier]; 
    if (cell == nil) { 
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:MoveMeCellIdentifier] autorelease]; 
        cell.showsReorderControl = YES; 
    } 
    NSUInteger row = [indexPath row]; 
    cell.textLabel.text = [list objectAtIndex:row]; 
	
    return cell; 
}

- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView 
           editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath { 
    return UITableViewCellEditingStyleNone; 
} 

- (BOOL)tableView:(UITableView *)tableView 
canMoveRowAtIndexPath:(NSIndexPath *)indexPath { 
    return YES; 
} 

- (void)tableView:(UITableView *)tableView 
moveRowAtIndexPath:(NSIndexPath *)fromIndexPath 
	  toIndexPath:(NSIndexPath *)toIndexPath { 
    NSUInteger fromRow = [fromIndexPath row]; 
    NSUInteger toRow = [toIndexPath row]; 
	
    id object = [[list objectAtIndex:fromRow] retain]; 
    [list removeObjectAtIndex:fromRow]; 
    [list insertObject:object atIndex:toRow]; 
    [object release]; 
} 

@end
